local InitializeSettings = function()
	local as = gSportsRNA
	local settingTable = as:GetTable("Settings")

	-- Force LevelOfDetail - 'high', 'medium', 'low', 'superlow'
	local levelOfDetail = as:GetString(settingTable, "LevelOfDetail") 
	if (levelOfDetail == "") then
		levelOfDetail = "high"
		as:SetString(settingTable, "LevelOfDetail", levelOfDetail)
	end

--	levelOfDetail = "medium"

	-- Set up defaults (high detail)
	as:SetInt(settingTable, "DropMipRX3_MipsToDrop", 0)			-- number of mips to drop from RX3 textures
	as:SetInt(settingTable, "DropMipRX3_MinTexDimension", 8192)	-- minimum size (here we will ignore the number of mips to drop)
	as:SetInt(settingTable, "FlatShadow_ScaleReduction", 0)		-- flat shadow dimensions 			(0 is normal, 1 is half, 2 is quarter, 3 is an eigth)
	as:SetInt(settingTable, "FlatShadow_MaxLights", 4)			-- max number of lights to allow
	as:SetInt(settingTable, "Jumbotron_ScaleReduction", 0)		-- jumbotron render scale reduction 
	as:SetInt(settingTable, "SelfShadow", 1)		
	as:SetInt(settingTable, "SelfShadow_ScaleReduction", 0)		-- selfshadow render scale reduction (0 normal, 1 half, 2 quartered)
	as:SetInt(settingTable, "PostFX_RainDrops", 1)
	as:SetInt(settingTable, "PostFX_AutoExp", 1)
	as:SetInt(settingTable, "PostFX_Bloom", 1)
	as:SetInt(settingTable, "PostFX_DOF", 1)
	as:SetInt(settingTable, "PostFX_Rectilinear", 1)
	as:SetInt(settingTable, "PostFX_Vignette", 1)
	as:SetInt(settingTable, "PostFX_ColorCube", 1)
	as:SetInt(settingTable, "PostFX_ColorCubeDepth", 1)

	as:SetInt(settingTable, "Grass", 1)
	as:SetInt(settingTable, "Cloth", 1)
	as:SetFloat(settingTable, "PlayerLodPercentageMultiplier", 50.0)
	as:SetInt(settingTable, "PlayerLodMinimum", 0)

	-- Override..
   	if (levelOfDetail == "medium") then

		as:SetInt(settingTable, "FlatShadow_ScaleReduction", 1)
		as:SetInt(settingTable, "FlatShadow_MaxLights", 4)	   
		as:SetInt(settingTable, "Jumbotron_ScaleReduction", 1) 
		as:SetInt(settingTable, "Grass", 0)
		as:SetInt(settingTable, "SelfShadow_ScaleReduction", 1)
		as:SetFloat(settingTable, "PlayerLodPercentageMultiplier", 50.0)

	elseif (levelOfDetail == "low" or levelOfDetail == "superlow") then
		-- Downsize Render to texture sizes and detail
		as:SetInt(settingTable, "DropMipRX3_MinTexDimension", 512)
		as:SetInt(settingTable, "DropMipRX3_MipsToDrop", 3)
		as:SetInt(settingTable, "FlatShadow_ScaleReduction", 1)
		as:SetInt(settingTable, "FlatShadow_MaxLights", 1) 
		as:SetInt(settingTable, "Jumbotron_ScaleReduction", 1) 
		as:SetInt(settingTable, "SelfShadow", 0)	

		-- Disable grass and cloth
		as:SetInt(settingTable, "Grass", 0)
		as:SetInt(settingTable, "Cloth", 0)

		-- disable pretty much all PostFX
		as:SetInt(settingTable, "PostFX_RainDrops", 0)
		as:SetInt(settingTable, "PostFX_AutoExp", 0)
		as:SetInt(settingTable, "PostFX_Bloom", 0)
		as:SetInt(settingTable, "PostFX_DOF", 0)
		as:SetInt(settingTable, "PostFX_Rectilinear", 0)
		as:SetInt(settingTable, "PostFX_Vignette", 0)	
		as:SetInt(settingTable, "PostFX_ColorCube", 0)
		as:SetInt(settingTable, "PostFX_ColorCubeDepth", 0)
	
		as:SetFloat(settingTable, "PlayerLodPercentageMultiplier", 25.00)
	end
	
	if (levelOfDetail == "superlow") then
		-- any extra tweaks here..
	end
end
InitializeSettings()
InitializeSettings = nil